
#include <iostream.h>
#include <fstream.h>

ifstream listfile;
ofstream libfile;
ifstream incfile;

int num_files = 0;
int file_pointer;

char libfname[13];
char listfname[13]="MAKELIB.TXT";
char incfname[13];
char string[200];


int file_size(char *fname)
{
int fsize = 0;
int byte;

	incfile.open(fname, ios::binary);

	while (incfile.read( (char*)&byte,1))
		fsize++;

	incfile.close();

	return fsize;
}


void build_incfname()
{
int c=0;
int ec=0;

     while (string[c]!=0 && string[c]!=46)
     {
         incfname[c]=string[c];
         c++;
     }

     ec=c;       //position of dot (if there's one)
     while (c<8)
     {
         incfname[c]=32;
         c++;//fill filename up with whitespaces
     }

     if (string[ec]==0)
     {
         incfname[8]=32;
         incfname[9]=32;
         incfname[10]=32;
     }
     else
     {
         ec++;
         while (string[ec]!=0)
         {
              incfname[c]=string[ec];
              ec++;
              c++;
         }

         while (c<11)
         {
             incfname[c]=32;
             c++;
         }
     }
}


void include_files()
{
	listfile.open(listfname);
	listfile.getline(libfname,13);	//Skip Library Name

	while (listfile.getline(string,200))
	{
		if (string[0]>64)
		{
			cout << "Including " << string << "...";
			incfile.open(string,ios::binary);
			incfile >> libfile.rdbuf();
			incfile.close();
			cout << "Done." << endl;
		}
	}

	listfile.close();
	libfile.close();
}


/*Build the library's directory
  Format: 2 bytes: number of files in directory
          per file: 16 bytes: file-info
                              11 bytes: filename
                              2 bytes: filesize
                              3 bytes: position in library
          1 byte: closing zero
*/
void build_directory()
{
unsigned char byte;
int fsize;

    cout << "Building library directory...";

    //calculate position of first file in directory
    file_pointer = 2 + 16 * num_files + 1;

    listfile.open(listfname);
    listfile.getline(libfname,13);      //Read Library Name
	cout << libfname;
    libfile.open(libfname, ios::binary);

    byte = (unsigned char)num_files;
    libfile.write( (char*)&byte,1);
    byte = (unsigned char)(num_files >> 8);
    libfile.write( (char*)&byte,1);     //write num_files to file

    byte = 0;
    libfile.write( (char*)&byte,1);     //closing zero

    while (listfile)
    {
        listfile.getline(string,200);
        if (string[0]>64)            //if it's a filename
        {
             build_incfname();//build the correct filename (8+3 chars)
             libfile << incfname;//and output it to the library's directory

             fsize = file_size(string);//get the size of the file
             byte = (unsigned char)fsize;
             libfile.write( (char*)&byte,1);
             byte = (unsigned char)(fsize/256);
             libfile.write( (char*)&byte,1);//and store it in the directory

             byte = (unsigned char)file_pointer;
             libfile.write( (char*)&byte,1);//Store the position
             byte = (unsigned char)(file_pointer >> 8);
             libfile.write( (char*)&byte,1);//of this file
             byte = (unsigned char)(file_pointer >> 16);
             libfile.write( (char*)&byte,1);//in the directory

             file_pointer+=(int)fsize;
        }
    }

    cout << "done." << endl;
    listfile.close();
}


void count_files()
{
    cout << "Counting number of files...";

    listfile.open(listfname);
    listfile.getline(string,200);       //skip library name

    while (listfile)
    {
        listfile.getline(string,200);
        if (string[0]>65)
            num_files++;
    }

    listfile.close();
    cout << num_files << " files counted." << endl;
}

int main()
{
	cout << "Start building library." << endl;

    count_files();      //count number of files to be included in library
    build_directory();  //build the directory of the library
	include_files();	//put all the files in the directory

	cout << "Library completed." << endl;

    return 0;
}

